local exhibits = {
	[50030] = {
		sounds = {
			{text = 'Hail |PLAYERNAME|, my friend!'},
			{text = 'Friends forever!'},
			{text = 'Look, how our friendship shines!'},
			{text = 'Hail Tibiafriends!'}
		},
		itemid = 9802,
		dir = DIRECTION_NORTH
	},
	[50031] = {
		sounds = {
			{text = 'Why so serious?'},
			{text = 'These are not the puppets you are looking for...'},
			{text = 'May the roleplay be with you.'},
			{text = 'An age of roleplay, and all will know, that three hundred puppets gave their last breath to defend it!'},
			{text = 'They stoles it! Sneaky little puppetses!'},
			{text = 'There was a dream that was roleplay. You could only whisper it. Anything more than a whisper and it would vanish.'}
		},
		itemid = 9189,
		dir = DIRECTION_WEST
	},
	[50032] = {
		sounds = {
			{text = 'Hauopa!'},
			{text = 'Yala Boom', exhibitEffect = CONST_ME_SOUND_RED},
			{text = 'Hail Portal Tibia!'}
		},
		itemid = 9144,
		transformid = 9145,
		dir = DIRECTION_NORTH
	},
	[50033] = {
		sounds = {
			{text = 'Hail TibiaNordic!'},
			{text = 'So cold...'},
			{text = 'Run, mammoth!'}
		},
		itemid = 8154,
		dir = DIRECTION_WEST
	},
	[50034] = {
		sounds = {
			{text = 'Hail Tibia Library!'},
			{text = 'Shhhhhh, please be quiet!'},
			{text = 'Books are great!! Aren\'t they?'}
		},
		itemid = 18343,
		dir = DIRECTION_NORTH
	},
	[50035] = {
		sounds = {
			{text = 'It\'s news to me.'},
			{text = 'News, updated as infrequently as possible!'},
			{text = 'Extra! Extra! Read all about it!'},
			{text = 'Fresh off the press!'}
		},
		itemid = 8153,
		dir = DIRECTION_NORTH
	},
	[50036] = {
		sounds = {
			{text = 'I own, Tibiacity owns, perfect match!'},
			{text = 'Weirdo, you\'re a weirdo! Actually all of you are!'},
			{text = 'All hail the control panel!'},
			{text = 'Pie for breakfast, pie for lunch and pie for dinner!'},
			{text = 'Hug me! Feed me! Hail me!'}
		},
		itemid = 8149,
		dir = DIRECTION_WEST
	},
	[50037] = {
		sounds = {
			{text = 'Oh, when I get my claws on you...'},
			{text = 'Let\'s hunt, |PLAYERNAME|!'},
			{text = 'Hail TibiaBR.com! Flap! Flap!'}
		},
		itemid = 8148,
		transformid = 8175,
		dir = DIRECTION_NORTH
	},
	[50038] = {
		sounds = {
			{text = 'I WILL PROTECT YOUR KNOWLEDGEZZZ.'},
			{text = 'FCHHH - FEEEEED ME AT TIBIAVENEZUELA.COM'},
			{text = 'I SENSE WISDOM...HUMILITY...AND...PERSEVERANCE!!!'},
			{text = 'MAY MY ETERNAL FLAME BE YOUR SHIELD AND PATH OF SUCCESS, |PLAYERNAME|!'}
		},
		itemid = 10477,
		dir = DIRECTION_NORTH
	},
	[50039] = {
		sounds = {
			{text = 'Mwahaha!'},
			{text = 'NO ONE WILL STOP ME THIS TIME!'},
			{text = 'THE POWER IS IN TIBIOPEDIA!'},
			{text = 'THE POWER IS MINE!'}
		},
		itemid = 10798,
		dir = DIRECTION_NORTH
	},
	[50040] = {
		sounds = {
			{text = 'Could a dead, frozen heart beat again? It felt like mine was about to.'},
			{text = 'The world was born from Tibiasula\'s love.'},
			{text = 'Look after TibiaTR\'s frozen heart. I\'ve left it with you.'},
			{text = 'Hail TibiaTR.net!'}
		},
		itemid = 12041,
		transformid = 12042,
		transformDuration = 12013,
		dir = DIRECTION_NORTH
	},
	[50041] = {
		sounds = {
			{text = 'For zze emperor!'},
			{text = 'Hail TibiaJourney.com!'},
			{text = 'Hail |PLAYERNAME|!'}
		},
		itemid = 12043,
		dir = DIRECTION_NORTH
	},
	[50042] = {
		itemids = {
			{
				itemid = 12045,
				transformid = 12046
			},
			{
				itemid = 12046,
				transformid = 12045
			}
		},
		dir = DIRECTION_NORTH
	},
	[50043] = {
		sounds = {
			{text = 'My powers are limitless!'},
			{text = 'Hail Tibia Bariloche!'}
		},
		itemid = 14764,
		dir = DIRECTION_NORTH
	},
	[50044] = {
		sounds = {
			{text = 'Do not trade me!'},
			{text = 'Hail |PLAYERNAME|!'},
			{text = 'Hail Tibia-Market!'}
		},
		itemid = 16262,
		dir = DIRECTION_NORTH
	},
	[50045] = {
		sounds = {
			{text = 'Uploading to TibiaEvents.... processing...'},
			{text = 'Say "Rat CHeese!"'},
			{text = 'I got the perfect shot!'},
			{text = 'Hold still...got it!'},
			{text = 'Look at this one! Wasn\'t this your first battle with a dragon?'},
			{text = 'This picture reminds me of the latest event.'}
		},
		itemid = 19397,
		transformid = 19398,
		transformDuration = 7000,
		dir = DIRECTION_WEST
	},
	[50046] = {
		itemid = 16275,
		transformid = 16276,
		dir = DIRECTION_NORTH
	},
	[50047] = {
		sounds = {
			{text = 'I will petrify thisss moment! Sstonesss are forever!!!'},
			{text = 'Where isss my body?!? I\'ll kill you!!!'}
		},
		itemid = 14762,
		dir = DIRECTION_NORTH
	},
	[50048] = {
		sounds = {
			{exhibitEffect = CONST_ME_LOSEENERGY}
		},
		itemid = 14760,
		transformid = 14761,
		dir = DIRECTION_NORTH
	},
	[50049] = {
		sounds = {
			{text = 'Now you will see, |PLAYERNAME|!'},
			{text = 'More eyes for many numbers!'},
			{text = '594!? So easy...'},
			{text = 'Numbers for Exhiti...'}
		},
		itemid = 12811,
		transformid = 12812,
		dir = DIRECTION_WEST
	},
	[50050] = {
		itemids = {
			{
				sounds = {
					{text = 'Now Tibia bffff... has sound.'},
					{text = 'Hail bffff... RadioTibia!'},
					{text = 'Hello bffff... |PLAYERNAME|.'}
				},
				itemid = 12813,
				transformid = 12814
			},
			{
				itemid = 12814,
				transformid = 12813
			}
		},
		dir = DIRECTION_NORTH
	},
	[50051] = {
		sounds = {
			{text = 'MY BRAIN... TOO MUCH... KNOWLEDGE! AAAAH!', playerEffect = CONST_ME_STUN},
			{text = 'Excalibug is lying at the heart of every true fighter.'},
			{text = 'Fire is fascinating. But whether it is going to light your path or burning you till death, you can never tell.'}
		},
		itemid = 12809,
		dir = DIRECTION_NORTH
	},
	[50052] = {
		sounds = {
			{text = 'Mhausheausheu! What a FAIL! Mwahaha!'},
			{text = 'Hail |PLAYERNAME|! You are wearing old socks!'},
			{text = 'ou are so unpopular even your own shadow refuses to follow you.'},
			{text = 'Have fun with FunTibia.com!'}
		},
		itemid = 12904,
		dir = DIRECTION_NORTH
	},
	[50053] = {
		sounds = {
			{text = 'Come closer, I will show some Tibian mysteries to you!'},
			{text = 'Feel the eternity of Tibiafans.se!'},
			{text = '|PLAYERNAME|, you are worthy to feel the power of Tibiafans.se! HAIL TIBIAFANS!'}
		},
		itemid = 4115,
		dir = DIRECTION_WEST
	},
	[50054] = {
		sounds = {
			{text = 'Hail |PLAYERNAME|!'},
			{text = 'Hail TibiaSpy.com!'},
			{text = 'Wrrrzzzgggrrzzzz...'},
			{text = 'Yummy...'}
		},
		itemid = 10800,
		dir = DIRECTION_NORTH
	},
	[50055] = {
		sounds = {
			{text = 'According to tibia-wiki.net, Jalapeño Peppers are as hot and famous as the place they come from - Ankrahmun.'},
			{text = 'According to tibia-wiki.net, a Bulb of Garlic is a great spice AND protection against vampires.'},
			{text = 'According to tibia-wiki.net, star and sling herbs taste like cinnamon and vanilla.'}
		},
		itemid = 10817,
		dir = DIRECTION_NORTH
	},
	[50056] = {
		sounds = {
			{text = 'Click! You don\'t seem experienced enough to open this properly.'},
			{text = 'Click! The box won\'t open for you.'},
			{text = 'Click! This item is too precious for a newbie. You are unable to open it.'}
		},
		itemid = 3997,
		transformid = 4010,
		transformDuration = 7000,
		dir = DIRECTION_NORTH
	},
}

local function resetExhibit(exhibitPosition, actionid)
	local settings = exhibits[actionid]
	if not settings.transformid then
		return
	end

	local exhibitItem = Tile(exhibitPosition):getItemById(settings.transformid)
	if exhibitItem then
		exhibitItem:transform(settings.itemid)
	end
end

local function resetLever(leverPos)
	local leverItem = Tile(leverPos):getItemById(2773)
	if leverItem then
		leverItem:transform(2772)
	end
end

local thaisExhibition = Action()

function thaisExhibition.onUse(player, item, fromPosition, target, toPosition, isHotkey)
	if item.itemid == 2773 then
		return false
	end

	local settings = exhibits[item.actionid]
	if not settings then
		return false
	end

	local exhibitPosition = fromPosition
	exhibitPosition:getNextPosition(settings.dir)

	local exhibitTile = Tile(exhibitPosition)
	local exhibitItem, isToggle = nil, false
	if settings.itemid then
		exhibitItem = exhibitTile:getItemById(settings.itemid)
	elseif settings.itemids then
		for i = 1, #settings.itemids do
			local tmpItem = exhibitTile:getItemById(settings.itemids[i].itemid)
			if tmpItem then
				exhibitItem = tmpItem
				isToggle = true
				settings = settings.itemids[i]
				break
			end
		end
	end

	if not exhibitItem then
		return false
	end

	if settings.sounds and #settings.sounds > 0 then
		local sound = settings.sounds[math.random(#settings.sounds)]
		if sound.text then
			player:say(sound.text:gsub('|PLAYERNAME|', player:getName()), TALKTYPE_MONSTER_SAY, false, nil, exhibitPosition)
		end

		if sound.exhibitEffect then
			exhibitPosition:sendMagicEffect(sound.exhibitEffect)
		end

		if sound.playerEffect then
			player:getPosition():sendMagicEffect(sound.playerEffect)
		end
	end

	if settings.transformid then
		exhibitItem:transform(settings.transformid)
	end

	item:transform(2773)
	addEvent(resetLever, 6000 or 6000, toPosition)

	if not isToggle then
		addEvent(resetExhibit, 6000 or 6000, exhibitPosition, item.actionid)
	end
	return true
end

for index, value in pairs(exhibits) do
	thaisExhibition:aid(index)
end

thaisExhibition:register()
